﻿using System;
using System.Collections.Generic;
using System.Text;

namespace KursBeispiele
{
    public class MyProperty
    {
        string name;
        string value;

        //Öffentlicher Konstruktor - setzt die Felder
        public MyProperty(string name, string value)
        {
            this.name = name;
            this.value = value;
        }

        //Nicht öffentlicher Konstruktor
        private MyProperty() : this(string.Empty, string.Empty)
        { }

        //Hier eignet sich ein statisches Feld um den leeren öffentlichen Konstruktor zu umgehen
        public static MyProperty Empty
        {
            get { return new MyProperty(); }
        }

        //Eigenschaften ohne SET - schreibgeschützt
        public string Name
        {
            get { return name; }
        }

        public string Value
        {
            get { return this.value; }
        }

        //Die ToString() wurde überschreiben - gewährleistet formatierte Ausgabe
        public override string ToString()
        {
            return name + ": " + value;
        }
    }
}
